//
//  NSImage+BWAdditions.h
//  BWToolkit
//
//  Created by Brandon Walkin (www.brandonwalkin.com)
//  All code is provided under the New BSD license.
//

#import <Cocoa/Cocoa.h>

@interface NSImage (BWAdditions)

// Draw a solid color over an image - taking into account alpha. Useful for coloring template images.
- (NSImage *)tintedImageWithColor:(NSColor *)tint NS_RETURNS_RETAINED;

// black stays black, white becomes transparent.
- (NSImage *)maskedImage NS_RETURNS_RETAINED;

- (void)drawTemplateInRect:(NSRect)rect dark:(BOOL)dark selected:(BOOL)isSelected active:(BOOL)active;

- (NSImage *)imageWithThreshold:(CGFloat)threshold colorValue:(CGFloat)colorValue;

@end
